define([
    'underscore',
    'App',
    'marionette',
    'modules/appointments/appointments-radio',

    'modules/appointments/list-section/appointments-list-item-view',
    'text!modules/appointments/requested/requested-appointments-list-item.html',

    'modules/appointments/list-section/appointments-list-view',
    'text!modules/appointments/requested/requested-appointments-list.html',
],
function (
    _,
    app,
    Marionette,
    radio,
    AppointmentsListItemView,
    childViewTemplate,
    AppointmentsListView,
    template
) {
    'use strict';

    // item view
    var MyItemView = AppointmentsListItemView.extend({
        template: childViewTemplate,
        // on 'click button': 'showDetails'
        showDetails: function() {
            radio.trigger('appointments:request:selected', this.model);
        },
        templateContext: function () {
            var practiceName;
            var bookedAddress;
            var locationName = this.model.get('friendlyLocationName') || this.model.get('facility').name;
            if (this.model.has('ccAppointmentRequest')) {
                this.setDisplayString();
            }
            practiceName = this.model.has('bookedAppointment') ?
                this.model.get('bookedAppointment').get('providerPractice') :
                '';

            bookedAddress = this.model.has('bookedAppointment') ?
                this.model.get('bookedAppointment').get('address') :
                '';
            return {
                bookedAddress: bookedAddress,
                practiceName: practiceName,
                ccIsDisabled: !_.isUndefined(app.disabledFeatures.get('CC_FEATURE_SET')),
                facilityName: locationName,
            };
        },

        setDisplayString: function() {
            var ccAppointmentRequest = this.model.get('ccAppointmentRequest');
            if (ccAppointmentRequest.preferredCity || ccAppointmentRequest.preferredState) {
                ccAppointmentRequest.cityState = ccAppointmentRequest.preferredCity ||
                    ccAppointmentRequest.preferredState;
                    
                if (ccAppointmentRequest.preferredCity && ccAppointmentRequest.preferredState) {
                    ccAppointmentRequest.cityState += ' ' + ccAppointmentRequest.preferredState;
                }
            }
            ccAppointmentRequest.displayLocation = $.grep([
                ccAppointmentRequest.cityState,
                ccAppointmentRequest.preferredZipCode,
            ], Boolean).join(', ');
        },
    });

    // composite view
    return AppointmentsListView.extend({
        template: template,
        childView: MyItemView,

        templateContext: function () {
            return {ccIsDisabled: !_.isUndefined(app.disabledFeatures.get('CC_FEATURE_SET'))};
        },
    });
});
